$(document).ready(function () {

  //-------------
  //- charts -
  //-------------- 
  /*
     * FULL WIDTH STATIC AREA CHART
     * -----------------
     */
  var areaData = [[2, 88.0], [3, 93.3], [4, 102.0], [5, 108.5], [6, 115.7], [7, 115.6],
  [8, 124.6], [9, 130.3], [10, 134.3], [11, 141.4], [12, 146.5], [13, 151.7], [14, 159.9],
  [15, 165.4], [16, 167.8], [17, 168.7], [18, 169.5], [19, 168.0]];
  if ($('#arrive-chart')[0]) {
    $.plot('#arrive-chart', [areaData], {
      grid: {
        borderWidth: 0
      },
      series: {
        shadowSize: 0, // Drawing is faster without shadows
        color: 'rgba(255, 195, 39, 1)',
        lines: {
          fill: true //Converts the line chart to area chart
        },
      },
      yaxis: {
        show: false
      },
      xaxis: {
        show: false
      }
    });
  }
  if ($('#delay-chart')[0]) {
    $.plot('#delay-chart', [areaData], {
      grid: {
        borderWidth: 0
      },
      series: {
        shadowSize: 0, // Drawing is faster without shadows
        color: 'rgba(91, 147, 255, 1)',
        lines: {
          fill: true //Converts the line chart to area chart
        },
      },
      yaxis: {
        show: false
      },
      xaxis: {
        show: false
      }
    });
  }
  if ($('#ontime-chart')[0]) {
    $.plot('#ontime-chart', [areaData], {
      grid: {
        borderWidth: 0
      },
      series: {
        shadowSize: 0, // Drawing is faster without shadows
        color: 'rgba(96, 91, 255, 1)',
        lines: {
          fill: true //Converts the line chart to area chart
        },
      },
      yaxis: {
        show: false
      },
      xaxis: {
        show: false
      }
    });
  }
  /* END AREA CHART */

  //-------------
  //- LINE CHART -
  //--------------

  var areaChartData = {
    labels: ['JAN', 'FEB', 'NOV', 'DES', 'OCT'],
    datasets: [
      {
        borderColor: '#6AD2FF',
        pointRadius: true,
        data: [28, 48, 40, 19, 86]
      },
      {
        pointRadius: true,
        borderColor: '#4318FF',
        data: [65, 59, 80, 81, 56]
      },
    ]
  }

  var chartOptions = {
    responsive: true,
    legend: {
      display: false
    },
    scales: {
      xAxes: [{
        gridLines: {
          display: false,
        }
      }],
      yAxes: [{
        display: false,
        gridLines: {
          display: false,
        }
      }]
    }
  }
  if ($('#monthChart')[0]) {
    var lineChartCanvas = $('#monthChart').get(0).getContext('2d')
    var lineChartOptions = $.extend(true, {}, chartOptions)
    lineChartOptions.datasetFill = false

    var lineChart = new Chart(lineChartCanvas, {
      type: 'line',
      data: {
        labels: ['JAN', 'FEB', 'NOV', 'DES', 'OCT'],
        datasets: [
          {
            borderColor: '#6AD2FF',
            pointRadius: true,
            data: [28, 48, 40, 19, 86],
            fill: false
          },
          {
            pointRadius: true,
            borderColor: '#4318FF',
            data: [65, 59, 80, 81, 56],
            fill: false
          },
        ]
      },
      options: lineChartOptions
    });
  }



  if ($('#StatisticalOrder')[0]) {
    var lineChartCanvas = $('#StatisticalOrder').get(0).getContext('2d')
    var lineChartOptions = $.extend(true, {}, chartOptions)
    lineChartOptions.datasetFill = false

    var lineChart = new Chart(lineChartCanvas, {
      type: 'line',
      data: {
        labels: ['1 Oct 2021', '2 Oct 2021', '3 Oct 2021', '4 Oct 2021', '5 Oct 2021'],
        datasets: [
          {
            borderColor: '#FB896B',
            pointRadius: true,
            data: [28, 48, 40, 19, 86],
            fill: false,
          },
          {
            pointRadius: true,
            borderColor: '#6956E5',
            data: [65, 59, 80, 81, 56],
            fill: false
          },
        ]
      },
      options: {
        responsive: true,
        legend: {
          display: true
        },
        scales: {
          xAxes: [{
            gridLines: {
              display: false,
            }
          }],
          yAxes: [{
            display: true,
            gridLines: {
              display: false,
            }
          }]
        }
      }
    });
  }

  /*
   * BAR CHART
   * ---------
   */

  var bar_data = {
    data: [[1, 10], [2, 8], [3, 4], [4, 13], [5, 17], [6, 9]],
    bars: { show: true }
  }
  if ($('#statisticsChart')[0]) {
    $.plot('#statisticsChart', [bar_data], {
      grid: {
        borderWidth: 0,
        borderColor: 'transparent',
        tickColor: 'transparent',
      },
      series: {
        bars: {
          show: true, barWidth: 0.5, align: 'center',
        },
      },
      colors: ['rgba(67, 24, 255, 1), rgba(67, 24, 255, 0.28)'],
      xaxis: {
        ticks: [[1, '00'], [2, '04'], [3, '08'], [4, '12'], [5, '14'], [6, '16']],
        tickLength: 0
      },
      yaxis: {
        ticks: [],
        tickLength: 0
      }

    })
  }



  //- PIE CHART -
  //-------------
  if ($('#mealsChart')[0]) {
    var pieChartCanvas = $('#mealsChart').get(0).getContext('2d')
    //Create pie chart
    new Chart(pieChartCanvas, {
      type: 'pie',
      data: {
        labels: [
          'arrived',
          'not arrived',
        ],
        datasets: [
          {
            data: [700, 400],
            backgroundColor: ['rgba(67, 24, 255, 1)', 'rgba(106, 210, 255, 1)'],
          }
        ]
      },
      options: {
        maintainAspectRatio: false,
        responsive: true,
      }
    });
  }

  if ($('#rateChart')[0]) {
    var pieChartCanvas = $('#rateChart').get(0).getContext('2d')
    //Create pie chart
    new Chart(pieChartCanvas, {
      type: 'pie',
      data: {
        labels: [
          'agree',
          'disagree',
        ],
        datasets: [
          {
            data: [700, 400],
            backgroundColor: ['#FF8F6B', '#3AC4FF'],
          }
        ]
      },
      options: {
        maintainAspectRatio: false,
        responsive: true,
      }
    });
  }

  //-------------
  //- DONUT CHART -
  //-------------
  // Get context with jQuery - using jQuery's .get() method.
  if ($('#archive_analysis')[0]) {
    var donutChartCanvas = $('#archive_analysis').get(0).getContext('2d')
    var donutData = {
      labels: [
        'Arrived (160)',
        'In Way (50)',
        'Not Arrived (20)',
      ],
      datasets: [
        {
          data: [700, 500, 400],
          backgroundColor: ['#FF8F6B', '#FFD66B', '#5B93FF'],
        }
      ]
    }
    var donutOptions = {
      maintainAspectRatio: false,
      responsive: true,
      legend: {
        position: 'bottom'
      }
    }
    //Create pie or douhnut chart
    // You can switch between pie and douhnut using the method below.
    new Chart(donutChartCanvas, {
      type: 'doughnut',
      data: donutData,
      options: donutOptions
    })

  }
  //   //-------------
  //   //- LINE CHART -
  //   //--------------
  if ($('#archive_report')[0]) {
    var lineChartCanvas2 = $('#archive_report').get(0).getContext('2d')
    var lineChartOptions = $.extend(true, {}, chartOptions)
    // var lineChartData = $.extend(true, {}, areaChartData)
    // lineChartData.datasets[0].fill = false;
    // lineChartData.datasets[1].fill = false;
    lineChartOptions.datasetFill = false;

    var lineChart = new Chart(lineChartCanvas2, {
      type: 'line',
      data: {
        labels: ['JAN', 'FEB', 'NOV', 'DES', 'OCT'],
        datasets: [
          {
            pointRadius: true,
            borderColor: 'rgb(255, 91, 239)',
            data: [65, 59, 80, 81, 56],
            fill: false
          },
        ]
      },
      options: {
        responsive: true,
        legend: {
          display: false
        },
        scales: {
          xAxes: [{
            gridLines: {
              display: true,
            }
          }],
          yAxes: [{
            display: true,
            gridLines: {
              display: true,
            }
          }]
        }
      }
    })
  }





  //-------------
  //- Date Range Btn -
  //--------------
  $('#daterange-btn').daterangepicker(
    {
      ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
      },
      startDate: moment().subtract(29, 'days'),
      endDate: moment()
    },
    function (start, end) {
      $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'))
    }
  )


  //-------------
  //- DataTables -
  //--------------


  // patients datatable
  $("#patients").DataTable({
    "searching": true, "ordering": true, "responsive": true,
    "lengthChange": false, "autoWidth": false, "info": false,
    "paging": false,
    order: [[1, "asc"]],
    columnDefs: [
      {
        orderable: false,
        className: 'select-checkbox',
        targets: 0
      }
    ],
    select: {
      style: 'multi',
      selector: 'td:first-child'
    },
    "buttons": [{
      orderable: true,
      extend: 'print',
      text: '<i class="fas fa-print mr-2"></i>print',
      title: '',
      rowReorder: true,
      pageSize: 'LEGAL',
      exportOptions: {
        columns: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
      },
      customize: function (win) {
        $(win.document.body).css({ margin: 0 })
        // add logo and title
        $(win.document.body).find('thead').each(function (index) {
          $(this).html('<tr><th colspan="13" style="text-align:center;padding-top:50px;padding-bottom:50px;"><img src="../dist/img/printLogo.png" style="margin-bottom:50px"><h3 style="font-size: 36px;">Sitter Menu وجبة المرافق </h3></th></tr>');
        });

        // add header
        $(win.document.body).find('tbody tr').each(function (index) {
          $(this).addClass('data');
          var text_arr = $('#patients').DataTable().columns().header().map(d => d.textContent).toArray().toString().split(",");
          for (i = 0; i < text_arr.length; i++) {
            text_arr[i] = "<h5>" + text_arr[i] + " </h5>";
          }
          $(this).prepend(`
            <td style="padding-left: 50px;width: 50%;"> `+ text_arr.join("")
            + ` </td>
              `)
        });

        $(win.document.body).find('tbody tr.data').each(function (index) {
          $(this).after(`<tr class="break" style="width: 100%;background-color: white"><td style="padding-top: 100px;
          padding-bottom: 50px;width: 100%;background-color: white" colspan="13"><img src="../dist/img/barcode.png" style="height: 100px;"><br/><div style="padding-right: 80px; padding-left: 50px"><label style="font-size:24px;text-align:left;">Comment</label><textarea style="height: 150px;width:100%;background: #f0f0f0;border:none;resize:none;border-raduis:10px;margin-bottom:20px"></textarea></div><br/>
          <h4 style="padding-bottom: 20px; padding-top: 20px">لتجميع الصوانى والماء الساخن 40398</h4>
          
          <h4>لتغيير موعد الوجبات : 4687/2332</h4>
          <h4 style="padding-bottom: 20px">بعد الساعه 8 مساءا : 23938/2329</h4>
          
          <h4>  مواعيد تقديم الوجبات: الفطور  : 8:30 - 5:00 صباحا</h4>
          <h4>  الغداء  : 12:00 - 2:30 بعد الضهر</h4>
          <h4 style="padding-bottom: 50px">العشاء  : 6:00 - 8:00 مساءا</h4>
          <h4 style="padding-bottom: 20px;text-align: center">تمنياتنا لكم بالصحه والعافيه</h4>
          </td></tr>
          `);
        });




      }
    }],
    "language": {
      searchPlaceholder: "Search here...",
      search: "",
    },
    "dom": '<<"head"<"title"><"left-side"f<"date">B>>t>',
  }).buttons().container().appendTo('#patients_wrapper .col-md-6:eq(1)');

  // add title
  $("#patients_wrapper .head .title").html('<h3>patients</h3>');
  // add date
  $("#patients_wrapper .head .date").html('<div class="date-input"><label>date from</label><input type="text" id="min" name="min"></div><div class="date-input"><label>date to</label><input type="text" id="max" name="max"></div>');

  // select all
  selectAllRows('#patients')

  // search for individual column
  $('#patients thead th').each(function () {
    var title = $('#patients thead th').eq($(this).index()).text();
    $(this).append('<input type="text" placeholder="Search here...">');
    var table = $('#patients').DataTable();
    table.columns().eq(0).each(function (colIdx) {
      $('input[type="text"]', table.column(colIdx).header()).on('keyup change', function () {
        table.column(colIdx).search(this.value).draw();
      });
      $('input[type="text"]', table.column(colIdx).header()).on('click', function (e) {
        e.stopPropagation();
      });
    });
  });

  // date range search
  // Custom filtering function which will search data in column four between two values
  DataTable.ext.search.push(function (settings, data, dataIndex) {
    var min = minDate.val();
    var max = maxDate.val();
    var date = new Date(data[8]);

    if (
      (min === null && max === null) ||
      (min === null && date <= max) ||
      (min <= date && max === null) ||
      (min <= date && date <= max)
    ) {
      return true;
    }
    return false;
  });

  // Create date inputs
  minDate = new DateTime('#min', {
    format: 'D MMM YYYY'
  });
  maxDate = new DateTime('#max', {
    format: 'D MMM YYYY'
  });

  // DataTables initialisation
  var patientTable = new DataTable('#patients');

  // Refilter the table
  $('#min, #max').each(function () {
    $(this).on('change', () => patientTable.draw());
  });


  // track datatable
  $("#track").DataTable({
    "searching": true, "ordering": true, "responsive": true,
    "lengthChange": false, "autoWidth": false, "info": false,
    "paging": false,
    order: [[1, "asc"]],
    columnDefs: [
      {
        orderable: false,
        className: 'select-checkbox',
        targets: 0
      }
    ],
    select: {
      style: 'multi',
      selector: 'td:first-child'
    },
    "buttons": [{
      orderable: true,
      extend: 'excel',
      text: 'download <i class="fas fa-cloud-download-alt"></i>',
      title: '',
      rowReorder: true,
      pageSize: 'LEGAL',
      exportOptions: {
        columns: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
      }
    }
    ],
    "language": {
      searchPlaceholder: "Search here...",
      search: "",
    },
    "dom": '<<"head"<"title"><"left-side"<"date">B>><"trackFilter">t>',
  }).buttons().container().appendTo('#track_wrapper .col-md-6:eq(1)');
  $("#track_wrapper .head .title").html('<h3>track</h3>');
  $("#track_wrapper .head .date").html('<div class="date-input"><label>date from</label><input type="text" id="checkin" name="checkin"></div><div class="date-input"><label>date to</label><input type="text" id="checkout" name="checkout"></div>');
  $("#track_wrapper .trackFilter").html(`
  <div>
  <input type="checkbox" class="btn-check" id="all" value="all">
  <label class="btn" for="all">all</label>
  </div>
  <div>
  <input type="checkbox" class="btn-check" id="arrived" value="arrived">
  <label class="btn" for="arrived">arrived</label>
  </div>
  <div>
  <input type="checkbox" class="btn-check" id="inway" value="in way">
  <label class="btn" for="inway">in way</label>
  </div>
  <div>
  <input type="checkbox" class="btn-check" id="notarrived" value="not arrived">
  <label class="btn" for="notarrived">not arrived</label>
  </div>
  `)

  // checkboxes filter
  $("#track_wrapper .trackFilter div input").on("change", function (e) {
    var searchTerms = [];
    $.each($("#track_wrapper .trackFilter div input"), function (i, elem) {
      if ($(elem).is(':checked')) {
        if ($(this).val() != "all") {
          searchTerms.push("^" + $(this).val() + "$");
        } else {
          searchTerms = []
        }
      }
    });
    $('#track').DataTable().column(5).search(searchTerms.join("|"), true, false, true).draw();

  });

  // select all
  selectAllRows('#track')

  // Create date inputs
  checkin = new DateTime('#checkin', {
    format: 'D MMM YYYY HH:mm A'
  });
  checkout = new DateTime('#checkout', {
    format: 'D MMM YYYY HH:mm A'
  });

  // date range search
  // Custom filtering function which will search data in column four between two values
  $.fn.dataTable.ext.search.push(
    function (settings, data, dataIndex) {
      var min = checkin.val();
      var max = checkout.val();
      var fromDate = new Date(data[8]);
      var toDate = new Date(data[9]);

      if (
        (min === null && max === null) ||
        (min === null && toDate <= max) ||
        (min <= fromDate && max === null) ||
        (min <= fromDate && toDate <= max)
      ) {
        return true;
      }
      return false;
    }
  );

  // DataTables initialisation
  var trackTable = new DataTable('#track');

  // Refilter the table
  $('#checkin, #checkout').each(function () {
    $(this).on('change', () => trackTable.draw());
  });


  // employee datatable
  $("#employee").DataTable({
    "searching": true, "ordering": true, "responsive": true,
    "lengthChange": false, "autoWidth": false, "info": false,
    "paging": false,
    order: [[1, "asc"]],
    columnDefs: [
      {
        orderable: false,
        className: 'select-checkbox',
        targets: 0
      }
    ],
    select: {
      style: 'multi',
      selector: 'td:first-child'
    },
    "buttons": [{
      orderable: true,
      extend: 'excel',
      text: 'download <i class="fas fa-cloud-download-alt"></i>',
      title: '',
      rowReorder: true,
      pageSize: 'LEGAL',
      exportOptions: {
        columns: [1, 2, 3, 4, 5, 6, 7]
      }
    }
    ],
    "language": {
      searchPlaceholder: "Search here...",
      search: "",
    },
    "dom": '<<"head"<"title"><"left-side"<"date">B>>t>',
  }).buttons().container().appendTo('#employee_wrapper .col-md-6:eq(1)');
  $("#employee_wrapper .head .title").html('<h3>employee</h3>');

  $("#employee_wrapper .head .date").html('<div class="date-input"><label>date from</label><input type="text" id="from" name="from"></div><div class="date-input"><label>date to</label><input type="text" id="to" name="to"></div>');

  // select all
  selectAllRows('#employee')

  // Create date inputs
  dateFrom = new DateTime('#from', {
    format: 'D MMM YYYY HH:mm A'
  });
  dateTo = new DateTime('#to', {
    format: 'D MMM YYYY HH:mm A'
  });

  // date range search
  // Custom filtering function which will search data in column four between two values
  $.fn.dataTable.ext.search.push(
    function (settings, data, dataIndex) {
      var min = dateFrom.val();
      var max = dateTo.val();
      var fromDate = new Date(data[6]);
      var toDate = new Date(data[7]);

      if (
        (min === null && max === null) ||
        (min === null && toDate <= max) ||
        (min <= fromDate && max === null) ||
        (min <= fromDate && toDate <= max)
      ) {
        return true;
      }
      return false;
    }
  );

  // DataTables initialisation
  var employeeTable = new DataTable('#employee');

  // Refilter the table
  $('#from, #to').each(function () {
    $(this).on('change', () => employeeTable.draw());
  });

  // archive datatable
  $("#archive").DataTable({
    "searching": false, "ordering": true, "responsive": true,
    "lengthChange": false, "autoWidth": false, "info": false,
    "paging": false,
    order: [[1, "asc"]],
    columnDefs: [
      {
        orderable: false,
        className: 'select-checkbox',
        targets: 0
      }
    ],
    select: {
      style: 'multi',
      selector: 'td:first-child'
    },
  })

  // select all
  selectAllRows('#archive')

  // review table 
  $("#review").DataTable({
    "searching": false, "ordering": true, "responsive": true,
    "lengthChange": false, "autoWidth": false, "info": false,
    "paging": false,
    order: [[1, "asc"]],
    columnDefs: [
      {
        orderable: false,
        className: 'select-checkbox',
        targets: 0
      }
    ],
    select: {
      style: 'multi',
      selector: 'td:first-child'
    },
  })

  // select all
  selectAllRows('#review')

  // orders datatable
  $("#orders").DataTable({
    "searching": true, "ordering": true, "responsive": true,
    "lengthChange": false, "autoWidth": false, "info": false,
    "paging": false,
    order: [[1, "asc"]],
    columnDefs: [
      {
        orderable: false,
        className: 'select-checkbox',
        targets: 0
      }
    ],
    select: {
      style: 'multi',
      selector: 'td:first-child'
    },
    "buttons": [{
      orderable: true,
      extend: 'print',
      text: '<i class="fas fa-print mr-2"></i>print',
      title: '',
      rowReorder: true,
      pageSize: 'LEGAL',
      exportOptions: {
        columns: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
      },
      customize: function (win) {
        $(win.document.body).css({ margin: 0 })

        // add logo and title
        $(win.document.body).find('thead').each(function (index) {
          $(this).html('<tr><th colspan="13" style="text-align:center;padding-bottom:20px;"><img src="../dist/img/printLogo.png" style="margin-bottom:50px"><h3 style="font-size: 32px;">Sitter Menu وجبة المرافق </h3></th></tr>');
        });

        // add header
        $(win.document.body).find('tbody tr').each(function (index) {
          $(this).addClass('data');
          var text_arr = $('#orders').DataTable().columns().header().map(d => d.textContent).toArray().toString().split(",");
          for (i = 0; i < text_arr.length; i++) {
            text_arr[i] = "<h5>" + text_arr[i] + " </h5>";
          }
          $(this).prepend(`
            <td style="padding-left: 50px;width: 50%;"> `+ text_arr.join("")
            + ` </td>
              `)
        });

        $(win.document.body).find('tbody tr.data').each(function (index) {
          $(this).after(`<tr class="break" style="width: 100%;background-color: white"><td style="padding-top: 100px;
          padding-bottom: 50px;width: 100%;background-color: white" colspan="13"><img src="../dist/img/barcode.png" style="height: 100px;"><br/><div style="padding-right: 80px; padding-left: 50px"><label style="font-size:24px;text-align:left;">Comment</label><textarea style="height: 150px;width:100%;background: #f0f0f0;border:none;resize:none;border-raduis:10px;margin-bottom:20px"></textarea></div><br/>
          <h4 style="padding-bottom: 20px; padding-top: 20px">لتجميع الصوانى والماء الساخن 40398</h4>
          
          <h4>لتغيير موعد الوجبات : 4687/2332</h4>
          <h4 style="padding-bottom: 20px">بعد الساعه 8 مساءا : 23938/2329</h4>
          
          <h4>  مواعيد تقديم الوجبات: الفطور  : 8:30 - 5:00 صباحا</h4>
          <h4>  الغداء  : 12:00 - 2:30 بعد الضهر</h4>
          <h4 style="padding-bottom: 50px">العشاء  : 6:00 - 8:00 مساءا</h4>
          <h4 style="padding-bottom: 20px;text-align: center">تمنياتنا لكم بالصحه والعافيه</h4>
          </td></tr>
          `);
        });
      }
    }],
    "language": {
      searchPlaceholder: "Search here...",
      search: "",
    },
    "dom": '<<"head"<"title"><"left-side"f<"date">B>>t>',
  }).buttons().container().appendTo('#orders_wrapper .col-md-6:eq(1)');

  // add title
  $("#orders_wrapper .head .title").html('<h3>orders</h3>');
  // add date
  $("#orders_wrapper .head .date").html('<div class="date-input"><label>date from</label><input type="text" id="minAdmission" name="minAdmission"></div><div class="date-input"><label>date to</label><input type="text" id="maxAdmission" name="maxAdmission"></div>');

  // select all
  selectAllRows('#orders')



  // date range search
  // Custom filtering function which will search data in column four between two values
  DataTable.ext.search.push(function (settings, data, dataIndex) {
    var min = minAdmissionDate.val();
    var max = maxAdmissionDate.val();
    var date = new Date(data[11]);

    if (
      (min === null && max === null) ||
      (min === null && date <= max) ||
      (min <= date && max === null) ||
      (min <= date && date <= max)
    ) {
      return true;
    }
    return false;
  });

  // Create date inputs
  minAdmissionDate = new DateTime('#minAdmission', {
    format: 'D MMM YYYY HH:mm A'
  });
  maxAdmissionDate = new DateTime('#maxAdmission', {
    format: 'D MMM YYYY HH:mm A'
  });

  // DataTables initialisation
  var ordersTable = new DataTable('#orders');

  // Refilter the table
  $('#minAdmission, #maxAdmission').each(function () {
    $(this).on('change', () => ordersTable.draw());
  });



  // mealArchives datatable

  $("#mealArchives").DataTable({
    "searching": true, "ordering": true, "responsive": true,
    "lengthChange": false, "autoWidth": false, "info": false,
    "paging": false,
    order: [[1, "asc"]],
    columnDefs: [
      {
        targets: 0,
        orderable: false,
        className: 'select-checkbox',
      },
      {
        targets: 6,
        orderable: false,
        render: function (data, type, row, meta) {
          return '<a class="editbutton btn" href="#"><i class="fas fa-pen"></i></a><a class="delbutton btn" href="#"><i class="fas fa-trash-alt"/></a>';
        },
        disabled: true
      }
    ],
    select: {
      style: 'multi',
      selector: 'td:first-child'
    },
    "buttons": [{
      orderable: true,
      extend: 'print',
      text: '<i class="fas fa-print mr-2"></i>print',
      title: '',
      rowReorder: true,
      pageSize: 'LEGAL',
      exportOptions: {
        columns: [1, 2, 3, 4, 5]
      },
      customize: function (win) {
        $(win.document.body).css({ margin: 0 })

        // add logo and title
        $(win.document.body).find('thead').each(function (index) {
          $(this).html('<tr><th colspan="13" style="text-align:center;padding-top:50px;padding-bottom:50px;"><img src="../dist/img/printLogo.png" style="margin-bottom:50px"><h3 style="font-size: 36px;">Sitter Menu وجبة المرافق </h3></th></tr>');
        });

        // add header
        $(win.document.body).find('tbody tr').each(function (index) {
          $(this).addClass('data');
          var text_arr = $('#mealArchives').DataTable().columns().header().map(d => d.textContent).toArray().toString().split(",");
          for (i = 0; i < text_arr.length; i++) {
            text_arr[i] = "<h5>" + text_arr[i] + " </h5>";
          }
          $(this).prepend(`
            <td style="padding-left: 50px;width: 50%;"> `+ text_arr.join("")
            + ` </td>
              `)
        });

        $(win.document.body).find('tbody tr.data').each(function (index) {
          $(this).after(`<tr class="break" style="width: 100%;background-color: white"><td style="padding-top: 100px;
          padding-bottom: 50px;width: 100%;background-color: white" colspan="13"><img src="../dist/img/barcode.png" style="height: 100px;"><br/><div style="padding-right: 80px; padding-left: 50px"><label style="font-size:24px;text-align:left;">Comment</label><textarea style="height: 150px;width:100%;background: #f0f0f0;border:none;resize:none;border-raduis:10px;margin-bottom:20px"></textarea></div><br/>
          <h4 style="padding-bottom: 20px; padding-top: 20px">لتجميع الصوانى والماء الساخن 40398</h4>
          
          <h4>لتغيير موعد الوجبات : 4687/2332</h4>
          <h4 style="padding-bottom: 20px">بعد الساعه 8 مساءا : 23938/2329</h4>
          
          <h4>  مواعيد تقديم الوجبات: الفطور  : 8:30 - 5:00 صباحا</h4>
          <h4>  الغداء  : 12:00 - 2:30 بعد الضهر</h4>
          <h4 style="padding-bottom: 50px">العشاء  : 6:00 - 8:00 مساءا</h4>
          <h4 style="padding-bottom: 20px;text-align: center">تمنياتنا لكم بالصحه والعافيه</h4>
          </td></tr>
          `);
        });




      },
    }],
    "language": {
      searchPlaceholder: "Search here...",
      search: "",
    },
    "dom": '<<"head"<"title"><"left-side"f<"date">B>>t>',
  }).buttons().container().appendTo('#mealArchives_wrapper .col-md-6:eq(1)');
  $("#mealArchives_wrapper .head .title").html('<h3>meal archives</h3>');

  $("#mealArchives_wrapper .head .date").html('<div class="date-input"><label>date from</label><input type="text" id="mealFrom" name="mealFrom"></div><div class="date-input"><label>date to</label><input type="text" id="mealTo" name="mealTo"></div>');
  $("#mealArchives_wrapper thead th:first-of-type").html('<input class="form-control" type="checkbox" id="selectAll">');
  // select all
  selectAllRows('#mealArchives')

  // // Create date inputs
  dateMealFrom = new DateTime('#mealFrom', {
    format: 'D MMM YYYY'
  });
  dateMealTo = new DateTime('#mealTo', {
    format: 'D MMM YYYY'
  });

  // // date range search
  // // Custom filtering function which will search data in column four between two values
  $.fn.dataTable.ext.search.push(
    function (settings, data, dataIndex) {
      var min = dateMealFrom.val();
      var max = dateMealTo.val();
      var fromDate = new Date(data[3]);
      var toDate = new Date(data[4]);

      if (
        (min === null && max === null) ||
        (min === null && toDate <= max) ||
        (min <= fromDate && max === null) ||
        (min <= fromDate && toDate <= max)
      ) {
        return true;
      }
      return false;
    }
  );

  // // DataTables initialisation
  var mealArchivesTable = new DataTable('#mealArchives');
  // // Refilter the table
  $('#mealFrom, #mealTo').each(function () {
    $(this).on('change', () => mealArchivesTable.draw());
  });

  // del row
  $('#mealArchives tbody').on('click', '.delbutton', function () {
    var mealArchivesTable = new DataTable('#mealArchives');

    mealArchivesTable
      .row($(this).parents('tr'))
      .remove()
      .draw();
  });

  // edit row
  $('#mealArchives tbody').on('click', '.editbutton', function () {
    var mealArchivesTable = new DataTable('#mealArchives');
    var rowID = mealArchivesTable.row($(this).parents('tr')).index();
    var data = mealArchivesTable.row($(this).parents('tr')).data().toString().replace(/<\/?[^>]+(>|$)/g, "").slice(1, -1);
    var arr = data.split(",");
    $('#editMealArchives').modal('show');
    $('#editMealArchives').find('.form-control').each(function (index, data) {
      $(this).val(arr[index]);
    });
    $('#editRow').on('click', function (e) {
      e.preventDefault();
      $('#editMealArchives').modal('hide');
      mealArchivesTable.cell({ row: rowID, column: 5 }).data($('#editMealArchives').find('#note').val());
      mealArchivesTable.cell({ row: rowID, column: 3 }).data('<i class="fas fa-calendar-alt"></i>' + $('#editMealArchives').find('#dateFrom').val());
      mealArchivesTable.cell({ row: rowID, column: 1 }).data($('#editMealArchives').find('#code').val());
      mealArchivesTable.cell({ row: rowID, column: 2 }).data($('#editMealArchives').find('#mealType').val());
      mealArchivesTable.cell({ row: rowID, column: 4 }).data('<i class="fas fa-calendar-alt"></i>' + $('#editMealArchives').find('#dateTo').val());
    })
  });



  // mealSchedule datatable
  $("#mealSchedule").DataTable({
    "searching": true, "ordering": true, "responsive": true,
    "lengthChange": false, "autoWidth": false, "info": false,
    "paging": false,
    order: [[1, "asc"]],
    columnDefs: [
      {
        orderable: false,
        className: 'select-checkbox',
        targets: 0
      },
      {
        targets: 7,
        orderable: false,
        render: function (data, type, row, meta) {
          return '<a class="editbutton btn" href="#"><i class="fas fa-pen"></i></a><a class="delbutton btn" href="#"><i class="fas fa-trash-alt"/></a>';
        },
        disabled: true
      }
    ],
    select: {
      style: 'multi',
      selector: 'td:first-child'
    },
    "buttons": [{
      orderable: true,
      extend: 'print',
      text: '<i class="fas fa-print mr-2"></i>print',
      title: '',
      rowReorder: true,
      pageSize: 'LEGAL',
      exportOptions: {
        columns: [1, 2, 3, 4, 5, 6]
      },
      customize: function (win) {
        $(win.document.body).css({ margin: 0 })

        // add logo and title
        $(win.document.body).find('thead').each(function (index) {
          $(this).html('<tr><th colspan="13" style="text-align:center;padding-top:50px;padding-bottom:50px;"><img src="../dist/img/printLogo.png" style="margin-bottom:50px"><h3 style="font-size: 36px;">Sitter Menu وجبة المرافق </h3></th></tr>');
        });

        // add header
        $(win.document.body).find('tbody tr').each(function (index) {
          $(this).addClass('data');
          var text_arr = $('#mealSchedule').DataTable().columns().header().map(d => d.textContent).toArray().toString().split(",");
          for (i = 0; i < text_arr.length; i++) {
            text_arr[i] = "<h5>" + text_arr[i] + " </h5>";
          }
          $(this).prepend(`
            <td style="padding-left: 50px;width: 50%;"> `+ text_arr.join("")
            + ` </td>
              `)
        });

        $(win.document.body).find('tbody tr.data').each(function (index) {
          $(this).after(`<tr class="break" style="width: 100%;background-color: white"><td style="padding-top: 100px;
          padding-bottom: 50px;width: 100%;background-color: white" colspan="13"><img src="../dist/img/barcode.png" style="height: 100px;"><br/><div style="padding-right: 80px; padding-left: 50px"><label style="font-size:24px;text-align:left;">Comment</label><textarea style="height: 150px;width:100%;background: #f0f0f0;border:none;resize:none;border-raduis:10px;margin-bottom:20px"></textarea></div><br/>
          <h4 style="padding-bottom: 20px; padding-top: 20px">لتجميع الصوانى والماء الساخن 40398</h4>
          
          <h4>لتغيير موعد الوجبات : 4687/2332</h4>
          <h4 style="padding-bottom: 20px">بعد الساعه 8 مساءا : 23938/2329</h4>
          
          <h4>  مواعيد تقديم الوجبات: الفطور  : 8:30 - 5:00 صباحا</h4>
          <h4>  الغداء  : 12:00 - 2:30 بعد الضهر</h4>
          <h4 style="padding-bottom: 50px">العشاء  : 6:00 - 8:00 مساءا</h4>
          <h4 style="padding-bottom: 20px;text-align: center">تمنياتنا لكم بالصحه والعافيه</h4>
          </td></tr>
          `);
        });




      },
    }],
    "language": {
      searchPlaceholder: "Search here...",
      search: "",
    },
    "dom": '<<"head"<"title"><"left-side"f<"date">B>>t>',
  }).buttons().container().appendTo('#mealSchedule_wrapper .col-md-6:eq(1)');
  $("#mealSchedule_wrapper .head .title").html('<h3>meal schedule</h3>');

  $("#mealSchedule_wrapper .head .date").html('<div class="date-input"><label>date from</label><input type="text" id="scheduleFrom" name="scheduleFrom"></div><div class="date-input"><label>date to</label><input type="text" id="scheduleTo" name="scheduleTo"></div>');

  // // select all
  selectAllRows('#mealSchedule')

  // // Create date inputs
  minScheduleDate = new DateTime('#scheduleFrom', {
    format: 'D MMM YYYY'
  });
  maxScheduleDate = new DateTime('#scheduleTo', {
    format: 'D MMM YYYY'
  });

  // // date range search
  // // Custom filtering function which will search data in column four between two values
  DataTable.ext.search.push(function (settings, data, dataIndex) {
    var min = minScheduleDate.val();
    var max = maxScheduleDate.val();
    var date = new Date(data[2]);

    if (
      (min === null && max === null) ||
      (min === null && date <= max) ||
      (min <= date && max === null) ||
      (min <= date && date <= max)
    ) {
      return true;
    }
    return false;
  });



  // // DataTables initialisation
  var scheduleTable = new DataTable('#mealSchedule');

  // // Refilter the table
  $('#scheduleFrom, #scheduleTo').each(function () {
    $(this).on('change', () => scheduleTable.draw());
  });

  // del row
  $('#mealSchedule tbody').on('click', '.delbutton', function () {
    var mealScheduleTable = new DataTable('#mealSchedule');
    mealScheduleTable
      .row($(this).parents('tr'))
      .remove()
      .draw();
  });

  // edit row
  $('#mealSchedule tbody').on('click', '.editbutton', function () {
    var mealScheduleTable = new DataTable('#mealSchedule');
    var ID = mealScheduleTable.row($(this).parents('tr')).index();
    var data = mealScheduleTable.row($(this).parents('tr')).data().toString().replace(/<\/?[^>]+(>|$)/g, "").slice(1, -1);
    var arr = data.split(",");
    $('#editMealSchedule').modal('show');
    $('#editMealSchedule').find('.form-control').each(function (index, data) {
      $(this).val(arr[index]);
    });
    $('#editschedule').on('click', function (e) {
      e.preventDefault();
      $('#editMealSchedule').modal('hide');
      mealScheduleTable.cell({ row: ID, column: 1 }).data($('#editMealSchedule').find('#day').val());
      mealScheduleTable.cell({ row: ID, column: 2 }).data('<i class="fas fa-calendar-alt"></i>' + $('#editMealSchedule').find('#date').val());
      mealScheduleTable.cell({ row: ID, column: 3 }).data($('#editMealSchedule').find('#mealType').val());
      mealScheduleTable.cell({ row: ID, column: 4 }).data($('#editMealSchedule').find('#breakfast').val());
      mealScheduleTable.cell({ row: ID, column: 5 }).data($('#editMealSchedule').find('#launch').val());
      mealScheduleTable.cell({ row: ID, column: 6 }).data($('#editMealSchedule').find('#dinner').val());

    })
  });


  // add meal in meal modal
  $('#addMeal #add').on('click', function (e) {
    e.preventDefault();
    mealType = $('#mealType').val();
    mealDetails = $('#dietDetails').val();
    mealDay = $('#mealDay').val();
    console.log(mealType + mealDetails + mealDay);
    meal = ("<div class='single-meal'><span><i class='fas fa-clock'></i></span><ul class='list-unstyled'><li>" + mealType + " meal (" + mealDetails + ")</li><li>" + mealDay + "</li></ul></div>")
    $('.meal_list').append(meal);
  });
});




// function to select all rows in datatable // take table id
function selectAllRows(table) {
  if ($.fn.DataTable.isDataTable(table)) {
    $("" + table + "_wrapper #selectAll").on("click", function (e) {
      if ($(this).is(":checked")) {
        $(table).dataTable().api().rows().select();
      } else {
        $(table).dataTable().api().rows().deselect();
      }
    });
  }
}